<?php

/**
 * Extracts symbol objects from symbol objects and child symbol objects from all of the membranes
 * @param array $membranes
 * @return array Array of symbol objects and children
 */
function extractSymbolObjects(array &$membranes): array {
    $extracted = [];
    foreach ($membranes as $membraneId => $m) {
        $extracted = array_merge($extracted, $m['symbolObjects'], $m['children']);
        $membranes[$membraneId]['symbolObjects'] = [];
        $membranes[$membraneId]['children'] = [];
        $membranes[$membraneId]['fronts'] = [];
        $membranes[$membraneId]['pairings'] = [];
    }

    $totalSymbolObjs = sizeof($extracted);

    for($i = 0; $i < $totalSymbolObjs; $i++) {
        $extracted[$i]['id'] = $i;
    }

    return $extracted;
}
