<?php

use Laminas\Math\Rand;

CONST ELITE_MATE_PERCENTAGE = 50;

/**
 * Assign mates for population within a membrane
 * 
 * @param array $membrane
 * @return array
 */
function assignMate(array $membrane, float $eliteMatePercentage = 50): array {
    
    $fronts = $membrane['fronts'];
    $symbolObjects = $membrane['symbolObjects'];
    $count = 0;
    $pairings = [
            //[mate1, mate2]
    ];
    $parts = [
        0 => [], //Better solutions
        1 => [], //Worse solutions
    ];
    $noOfSymbolObjs = sizeof($symbolObjects);
    $partsCount = [
        0 => (int)floor($noOfSymbolObjs * $eliteMatePercentage / 100),
        1 => (int)($noOfSymbolObjs - floor($noOfSymbolObjs * $eliteMatePercentage / 100))
    ];

    foreach ($fronts as $frontNo => $front) {
        foreach ($front as $symbolObjId) {
            $parts[$count < $partsCount[0] ? 0 : 1][] = [
                'symbolObjectId' => $symbolObjId,
                'frontNo' => $frontNo
            ];
            $count++;
        }
    }
    
    //\Symfony\Component\VarDumper\VarDumper::dump($parts);
    //\Symfony\Component\VarDumper\VarDumper::dump($partsCount);
    //die();
    
    do {
        //Selects first mate from better solutions using randomly
        $mate1 = $parts[0][Rand::getInteger(0, abs($partsCount[0] - 1))];

        //Select second mate
        $partNo = Rand::getInteger(0, 1);
        $mate2 = $parts[$partNo][Rand::getInteger(0, abs($partsCount[$partNo] - 1))];

        if ($mate1['symbolObjectId'] !== $mate2['symbolObjectId']) {
            $pairings[] = [
                'parent1' => $mate1,
                'parent2' => $mate2
            ];
        }
    } while (sizeof($pairings) < $noOfSymbolObjs);
    return $pairings;
}
