<?php

/**
 * 
 * 
 * @param array $membranes
 * @param int $symbolObjectsPerMembrane
 * @param int $desiredMembraneCountAfterMerge
 * @return bool Number of membranes merged
 */
function merge(
        array &$membranes,
        int $symbolObjectsPerMembrane,
        int $desiredMembraneCountAfterMerge,
        float $thresholdForMerge = 50,
): bool {
    $mergeThreshold = (int) ($symbolObjectsPerMembrane * $thresholdForMerge / 100);
    $inputMembraneCount = sizeof($membranes);
    $counts = [];
    foreach ($membranes as $membraneId => $m) {
        $symbolObjCount = sizeof($m['symbolObjects']);
        $counts[$membraneId] = $symbolObjCount;
    }

    uasort($counts, "associativeSort");

    foreach ($counts as $membraneId => $symbolObjCount) {
        $neighbours = $membranes[$membraneId]['neighbours'];
        $symbolObjCount = sizeof($membranes[$membraneId]);
        $min = INF;
        $minId = NULL;

        if ($symbolObjCount == 0) {
            unset($membranes[$membraneId]);
            echo 'Empty membrane ! <br/>';
            $inputMembraneCount--;
            continue;
        }

        //Find neighbour membrane with enough symbol objects so that hen combined 
        //new membrane has number of symbol objects closest to $symbolObjectsPerMembrane
        foreach ($neighbours as $n) {
            //This memrane may have been merged in previous iteration
            if (!isset($membranes[$n])) {
                continue;
            }
            if ($membraneId == $n) {
                continue;
            }
            $neighbourSymbolObjCount = sizeof($membranes[$n]['symbolObjects']);

            //If this neighbour does not have enough symbol objects continue
            if (($symbolObjCount + $neighbourSymbolObjCount) < $mergeThreshold) {
                continue;
            }
            $tmp = abs($symbolObjectsPerMembrane - ($symbolObjCount + $neighbourSymbolObjCount));
            if ($min > $tmp) {
                $min = $tmp;
                $minId = $n;
            }
        }
        if (!is_null($minId)) {
            //echo "Merging $membraneId into $minId<br/>";
            $membranes[$minId]['symbolObjects'] = array_merge($membranes[$minId]['symbolObjects'], $membranes[$membraneId]['symbolObjects']);
            $membranes[$minId]['neighbours'] = array_unique(array_merge($membranes[$minId]['neighbours'], $membranes[$membraneId]['neighbours']));
            unset($membranes[$membraneId]);
            
            $membranes[$minId]['mergedMembraneIds'][] = $membraneId;
            
            foreach ($membranes[$minId]['neighbours'] as $n) {
                if (!isset($membranes[$n])) {
                    continue;
                }
                $membranes[$n]['neighbours'] = array_unique(array_merge($membranes[$n]['neighbours'], [$minId]));
            }
            
            $cleanNeighbours = [];
            foreach($membranes[$minId]['neighbours'] as $tmp){
                if($tmp == $minId){
                    continue;
                }
                $cleanNeighbours[] = $tmp;
            }
            $membranes[$minId]['neighbours'] = $cleanNeighbours;

            $inputMembraneCount--;
        }
        if ($inputMembraneCount == $desiredMembraneCountAfterMerge) {
            break;
        }
    }
    
    //Adjust indexes
    $tmp = $membranes;
    $membranes = [];
    $membraneCount = sizeof($tmp);
    $oldIdx = array_keys($tmp);
    $lookUp = [];
    $newSymbolObjCount = 0;

    foreach ($oldIdx as $key => $value) {
        $lookUp[$value] = $key;
    }

    for ($i = 0; $i < $membraneCount; $i++) {
        $symbolObjs = array_values($tmp[$oldIdx[$i]]['symbolObjects']);
        $neighbours = array_values($tmp[$oldIdx[$i]]['neighbours']);

        $tmp[$oldIdx[$i]]['symbolObjects'] = [];
        $tmp[$oldIdx[$i]]['neighbours'] = [];

        $membranes[$i] = $tmp[$oldIdx[$i]];
        $membranes[$i]['id'] = $i;
        foreach ($symbolObjs as $s) {
            $s['id'] = $newSymbolObjCount;
            $s['membraneId'] = $i;
            $membranes[$i]['symbolObjects'][$s['id']] = $s;
            $newSymbolObjCount++;
        }

        foreach ($neighbours as $n) {
            if (!isset($lookUp[$n])) {
                continue;
            }
            $membranes[$i]['neighbours'][] = $lookUp[$n];
        }
    }
    
    return true;
}

/**
 * 
 * @param array $membranes
 * @param int $symbolObjectsPerMembrane
 * @param int $thresholdForDivision in percentage of population
 * @return int Number of new membranes created
 */
function divide(array &$membranes,
        int $symbolObjectsPerMembrane,
        float $thresholdForDivision = 150)
: int {
    $divisionIds = [];
    $divisionThreshold = (int) ($symbolObjectsPerMembrane * $thresholdForDivision / 100);
    $membraneCount = sizeof($membranes);
    $dividedCount = 0;

    foreach ($membranes as $membraneId => $m) {
        $symbolObjCount = sizeof($m['symbolObjects']);
        if ($symbolObjCount >= $divisionThreshold) {
            $divisionIds[] = $membraneId;
        }
    }

    //\Symfony\Component\VarDumper\VarDumper::dump($divisionIds);

    foreach ($divisionIds as $d) {
        $neighbours = $membranes[$d]['neighbours'];
        $neighbours[] = $d;

        $symbolObjects = $membranes[$d]['symbolObjects'];
        $parts = [];
        $toggle = false;
        foreach($symbolObjects as $s){
            $parts[(int)$toggle][]= $s; 
            $toggle = !$toggle;
        }
        
        $membranes[$d]['symbolObjects'] = $parts[0];
        $membranes[$d]['neighbours'][] = $membraneCount;
        $newMembrane = [
            'id' => $membraneCount,
            'linearPosition' => null,
            'hyperCubePosition' => [],
            'symbolObjects' => $parts[1],
            'range' => [
                'lower' => null,
                'upper' => null,
            ],
            'mergedMembraneIds' => [],
            'neighbours' => $neighbours
        ];

        foreach ($neighbours as $n) {
            if (!isset($membranes[$n])) {
                continue;
            }
            $membranes[$n]['neighbours'] = array_unique(array_merge($membranes[$n]['neighbours'], [$membraneCount]));
        }
        
        $cleanNeighbours = [];
        foreach($membranes[$d]['neighbours'] as $tmp){
            if($tmp == $d){
                continue;
            }
            $cleanNeighbours[] = $tmp;
        }
        $membranes[$d]['neighbours'] = $cleanNeighbours;

        adjustSymbolObjectIndex($newMembrane);
        
        $membranes[$membraneCount] = $newMembrane;
        $membraneCount++;
        $dividedCount++;
    }
    return $dividedCount;
}

function adjustSymbolObjectIndex(&$membrane) : void {
    $newArray = [];
    $oldSymbolObjs = $membrane['symbolObjects'];
    foreach($oldSymbolObjs as $s){
        $newArray[$s['id']] = $s;
    }
    $membrane['symbolObjects'] = $newArray;
    return ;
}

function associativeSort($a, $b) {
    if ($a == $b) {
        return 0;
    }
    return ($a < $b) ? -1 : 1;
}
