<?php

use Laminas\Math\Rand;

function createOffsprings(
        array $membrane,
        string $objectiveEvaluator,
        float $betterParentPreference = 0.75,
        float $mutationChance = 0.01
): array {
    
    $childrens = [];
    $symbolObjects = $membrane['symbolObjects'];
    
    foreach ($membrane['pairings'] as $pair) {
        $parent1 = $pair['parent1'];
        $parent2 = $pair['parent2'];

        $symbolObject1 = $symbolObjects[$parent1['symbolObjectId']];
        $symbolObject2 = $symbolObjects[$parent2['symbolObjectId']];
        $front1 = $parent1['frontNo'];
        $front2 = $parent2['frontNo'];

        $parent1Weight = $parent2Weight = 0.5;
        if ($front1 > $front2) {
            $parent1Weight = $betterParentPreference;
        } elseif ($front1 > $front2) {
            $parent1Weight = 1.0 - $betterParentPreference;
        }

        $coordinate1 = $symbolObject1['coordinate'];
        $coordinate2 = $symbolObject2['coordinate'];
        $childCoordinate = [];
        $dimension = sizeof($coordinate1);

        for ($i = 0; $i < $dimension; $i++) {
            $parent1Weight += (Rand::getBoolean() ? 1 : -1) * Rand::getFloat() * $mutationChance;
            $parent2Weight = 1 - $parent1Weight;
            $childCoordinate[$i] = $coordinate1[$i] * $parent1Weight + $coordinate2[$i] * $parent2Weight;
        }

        $symbolObj = [
            'membraneId' => $membrane['id'],
            'coordinate' => $childCoordinate,
            'objectives' => getObjectiveValues($objectiveEvaluator, $childCoordinate),
        ];

        $childrens[] = $symbolObj;
    }
    return $childrens;
}
