<?php

function displayMDTable(array $dataArray, $titleArray = []): void {
    echo '<table class="table table-sm table-reponsive table-hover" border="1">';
    if (sizeof($titleArray) > 0) {
        echo '<thead><tr><th>' . implode('</th><th>', $titleArray) . '</th></tr></thead>';
    }
    echo '<tbody>';
    foreach ($dataArray as $s) {
        echo '<tr><td>' . implode('</td><td>', $s) . '</td></tr>';
    }
    echo '</tbody>';
    echo '</table>';
}

function displaySymbolObjectWithObjective($symbolObjectArray): void {
    $solutionDimension = sizeof($symbolObjectArray[array_keys($symbolObjectArray)[0]]['coordinate']);
    $noOfObjectives = sizeof($symbolObjectArray[array_keys($symbolObjectArray)[0]]['objectives']);
    echo '<table class="table table-sm table-reponsive table-hover" border="1">';
    echo '<thead>'
    . '<tr>'
    . '<th>SN.</th>'
    . '<th colspan="' . $solutionDimension . '">Solution</th>'
    . '<th colspan="' . $noOfObjectives . '">Objective</th>'
    . '</tr>'
    . '</thead>';
    echo '<tbody>';
    foreach ($symbolObjectArray as $key => $s) {
        echo '<tr><td>' . $key . '</td><td>'
        . implode('</td><td>', $s['coordinate'])
        . '<td>'
        . implode('</td><td>', $s['objectives'])
        . '</td></tr>';
    }
    echo '</tbody>';
    echo '</table>';
}

function displayFronts($frontArray, $symbolObjectArray): void {
    $solutionDimension = sizeof($symbolObjectArray[array_keys($symbolObjectArray)[0]]['coordinate']);
    $noOfObjectives = sizeof($symbolObjectArray[array_keys($symbolObjectArray)[0]]['objectives']);
    echo '<table class="table table-sm table-reponsive table-hover" border="1">';
    echo '<thead>'
    . '<tr>'
    . '<th>Front</th>'
    . '<th>ID.</th>'
    . '<th colspan="' . $solutionDimension . '">Solution</th>'
    . '<th colspan="' . $noOfObjectives . '">Objective</th>'
    . '</tr>'
    . '</thead>';
    echo '<tbody>';
    foreach ($frontArray as $frontNo => $front) {
        $objCount = sizeof($front);
        echo '<tr><td rowspan="' . $objCount . '"> ' . $frontNo . '</td>';
        foreach ($front as $key) {
            echo '<td>' . $key . '</td><td>'
            . implode('</td><td>', $symbolObjectArray[$key]['coordinate'])
            . '<td>'
            . implode('</td><td>', $symbolObjectArray[$key]['objectives'])
            . '</td></tr>';
        }
    }
    echo '</tbody>';
    echo '</table>';
}
