<?php

use Laminas\Math\Rand;

CONST LATINHYPERCUBEINITIALIZATION = 'latinHyperCubeInitialization';
CONST RANDOMINITIALIZATION = 'randomInitialization';

function getInitializationValues(
        string $initializationType,
        int $numSamples,
        int $numDimensions,
        array|float $lowerBound,
        array|float $upperBound
): array {
    if (!function_exists($initializationType)) {
        throw new \Exception("Initialization method with name $initializationType not found");
    }
    return call_user_func($initializationType, $numSamples, $numDimensions, $lowerBound, $upperBound);
}

function latinHyperCubeInitialization(
        int $numSamples,
        int $numDimensions,
        array|float $lowerBound,
        array|float $upperBound
): array {

    //If dimension wise range is not provided, give same range to all the dimensions
    if (!is_array($lowerBound)) {
        $lowerBound = array_fill(0, $numDimensions, $lowerBound);
    }
    //If dimension wise range is not provided, give same range to all the dimensions
    if (!is_array($upperBound)) {
        $upperBound = array_fill(0, $numDimensions, $upperBound);
    }

    $samples = [];
    $ret = [];
    for ($i = 0; $i < $numSamples; $i++) {
        for ($j = 0; $j < $numDimensions; $j++) {
            do {
                $randI = Rand::getInteger(0, $numSamples - 1);
            } while (isset($samples[$randI][$j]));
            $samples[$randI][$j] = $lowerBound[$j] + ($upperBound[$j] - $lowerBound[$j]) * ($i + Rand::getFloat(0, 1)) / $numSamples;
        }
    }
    for ($k = 0; $k < $numSamples; $k++) {
        for ($i = 0; $i < $numDimensions; $i++) {
            $ret[$k][$i] = $samples[$k][$i];
        }
    }
    $samples = null;
    return $ret;
}

function randomInitialization(
        int $numSamples,
        int $numDimensions,
        array|float $lowerBound,
        array|float $upperBound
): array {

    //If dimension wise range is not provided, give same range to all the dimensions
    if (!is_array($lowerBound)) {
        $lowerBound = array_fill(0, $numDimensions, $lowerBound);
    }
    //If dimension wise range is not provided, give same range to all the dimensions
    if (!is_array($upperBound)) {
        $upperBound = array_fill(0, $numDimensions, $upperBound);
    }
    
    $sample = [];
    
    for ($i = 0; $i < $numSamples; $i++) {
        $sample[$i] = array();
        for ($j = 0; $j < $numDimensions; $j++) {
            // Randomly select a value within the range for this dimension
            $value = $lowerBound[$j] + mt_rand() / mt_getrandmax() * ($upperBound[$j] - $lowerBound[$j]);
            $sample[$i][$j] = $value;
        }
    }

    return $sample;
}
