<?php

/**
 * Returns array of fronts containing ids of the solutions
 * @param array $population must contain 'objective' and 'id' key
 * @return array
 */
function sortPopulationByNonDomination(array $population) : array {
    $result = [];
    $front = [];
    $dominatedIndividuals = [];

    // Initialize the front and dominated individuals arrays
    foreach ($population as $individual) {
        $front[$individual['id']] = [];
        $dominatedIndividuals[$individual['id']] = 0;
    }

    // Determine which individuals dominate which others
    foreach ($population as $p) {
        foreach ($population as $q) {
            if ($p['id'] == $q['id']){
                continue;
            }
            $pIsDominating = true;
            $qIsDominate = true;
            for ($i = 0; $i < count($p['objectives']); $i++) {
                if ($p['objectives'][$i] < $q['objectives'][$i]) {
                    $pIsDominate = false;
                } elseif ($p['objectives'][$i] > $q['objectives'][$i]) {
                    $qIsDominate = false;
                }
            }
            if (isset($pIsDominate) && $pIsDominate == true) {
                $front[$q['id']][] = $p['id'];
                $dominatedIndividuals[$p['id']]++;
            }
            if (isset($qIsDominate) && $qIsDominate == true) {
                $front[$p['id']][] = $q['id'];
                $dominatedIndividuals[$q['id']]++;
            }
        }
    }

    // Sort individuals into fronts
    $frontCounter = 0;
    while (count($dominatedIndividuals) > 0) {
        $result[$frontCounter] = [];
        foreach ($dominatedIndividuals as $id => $count) {
            if ($count == 0) {
                unset($dominatedIndividuals[$id]);
                $result[$frontCounter][] = $id;
                foreach ($front[$id] as $dominatedId) {
                    $dominatedIndividuals[$dominatedId]--;
                }
            }
        }
        $frontCounter++;
    }

    return $result;
}
