<?php

CONST ZDT1 = 'zdt1';
CONST ZDT2 = 'zdt2';
CONST ZDT3 = 'zdt3';
CONST SCHAFFER1 = 'schf1';
CONST SCHAFFER2 = 'schf2';

function getObjectiveValues(string $problemName, array $x): array {
    return call_user_func($problemName, $x);
}

function getObjectiveValuesBulk(string $problemName, array $xx): array {
    $ret = [];
    foreach ($xx as $x){
        $ret[] = call_user_func($problemName, $x);
    }
    return $ret;
}

function zdt1(array $x): array {
    $f1 = $x[0];
    $g = 0;
    for ($i = 1; $i < count($x); $i++) {
        $g += $x[$i];
    }
    $g = 9 * $g / (count($x) - 1) + 1;
    $h = 1 - sqrt($f1 / $g);
    $f2 = $g * $h;
    return [$f1, $f2];
}

function zdt2(array $x): array {
    $f1 = $x[0];
    $g = 0;
    for ($i = 1; $i < count($x); $i++) {
        $g += $x[$i];
    }
    $g = 9 * $g / (count($x) - 1) + 1;
    $h = 1 - pow(($f1 / $g), 2);
    $f2 = $g * $h;
    return [$f1, $f2];
}

function zdt3(array $x): array {
    $f1 = $x[0];
    $g = 0;
    for ($i = 1; $i < count($x); $i++) {
        $g += $x[$i];
    }
    $g = 9 * $g / (count($x) - 1) + 1;
    $h = 1 - sqrt($f1 / $g) - ($f1 / $g) * sin(10 * pi() * $f1);
    $f2 = $g * $h;
    return [$f1, $f2];
}

function schf1(array $x) : array {
    return [
        $x[0]*$x[0],
        ($x[0]-2)*($x[0]-2)
    ];
}

function schf2(array $x) : array {
    $f1 = null;
    if($x[0] <= 1){
        $f1 = -$x[0];
    }elseif ($x[0] > 1 && $x[0] <3) {
        $f1 = $x[0] - 2;
    }elseif ($x[0] >= 3 && $x[0] <4) {
        $f1 = $x[0] - 2;
    }else{
        $f1 = 4-$x[0];
    }
    return [
        $f1,
        ($x[0]-2)*($x[0]-2)
    ];
}