<?php
require_once __DIR__ . '/../bootstrap.php';
?>
<!doctype html>
<html>
    <head>
        <title>Multi-Objective Optimization Using Membrane Inspired Evolutionary Algorithm</title>
        <script src="assets/jquery.js"></script>
    </head>
    <body>
        <h1>
            Introduction
        </h1>
        <p>
            This is demo application for "Multi-Objective Optimization Using Membrane Inspired Evolutionary Algorithm".
        </p>
        <h3>Algorithm Description</h3>
        <p style="text-align: justify">
        This algorithm works by partitioning decision space into multi-dimensional volumes (membranes).   Dimension of the membranes depends on the dimension of decision space. Symbol objects (solution, objective pairs) are initialized in each partition. Reproduction and mutation rules are applied inside each membrane. This will double the symbol object count. Then symbol objects are extracted from each membrane and sorted by non-domination. Half of the symbol objects are then rejected and remaining symbol objects are sent into corresponding membranes. At this point some of the membranes may contain more or less symbol objects than at the start. If a membrane contains more symbol objects; division rule is applied to it. If a membrane contains less symbol objects it is merged with its neighbor.
        </p>
       	<p>Use the form below to: </p>
        <ul>
            <li>
                Change the parameters of algorithm. 
            </li>
            <li>
                Select standard MOOP objective to optimize.
            </li>
        </ul>
        <form method="POST" id="optimizeForm" action="process-request.php">
            <fieldset>
                <legend>
                    <strong>Algorithm Parameters</strong>
                </legend>

                <table>
                    <tr>
                        <td>
                            <label>Initialization Method </label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="initializationType">
                                <option value="<?= LATINHYPERCUBEINITIALIZATION ?>">
                                    Latin Hypercube Initialization
                                </option>
                                <option value="<?= RANDOMINITIALIZATION ?>">
                                    Random Initialization
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Elite Mate Percentage </label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="eliteMatePercentage">
                                <option value="50">
                                    --Default (50)--
                                </option>
                                <option>10</option>
                                <option>20</option>
                                <option>30</option>
                                <option>40</option>
                                <option>60</option>
                                <option>70</option>
                                <option>80</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Mutation Rate </label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="mutationChance">
                                <option value="0.05">
                                    --Default (0.05)--
                                </option>
                                <option>0.02</option>
                                <option>0.04</option>
                                <option>0.06</option>
                                <option>0.08</option>
                                <option>0.1</option>
                                <option>0.25</option>
                                <option>0.5</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Merge/Divide Threshold</label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="mergeDivideThreshold">
                                <option value="50/150">
                                    --Default (50/150)--
                                </option>
                                <option>40/140</option>
                                <option>30/130</option>
                                <option>20/120</option>
                                <option>60/160</option>
                                <option>80/180</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Hyper Cube Dimension</label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="hyperCubeDimension">
                                <option value="__null__">
                                    --Same as decision dimension (MAX : 5)--
                                </option>
                                <option>2</option>
                                <option>3</option>
                                <option>4</option>
                                <option>5</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Partition per dimension</label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="partsPerDimension">
                                <option>2</option>
                                <option selected>4</option>
                                <option>6</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Symbol objects per membrane</label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="symbolObjectPerMembrane">
                                <option>10</option>
                                <option>15</option>
                                <option selected>20</option>
                                <option>40</option>
                                <option>50</option>
                            </select>
                        </td>
                    </tr>
                </table>
            </fieldset>
            <p></p>
            <fieldset>
                <legend>
                    <strong>Objective Function</strong>
                </legend>
                <table>
                    <tr>
                        <td>
                            <label>Objective to optimize</label>
                        </td>
                        <td>:</td>
                        <td>
                            <select name="objective">
                                <option><?= ZDT1 ?></option>
                                <option><?= ZDT2 ?></option>
                                <option><?= ZDT3 ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>No of Decision Variables (Decision space Dimension)</label>
                        </td>
                        <td>:</td>
                        <td>
                            <input name="dimension" value="2">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Lower Bound</label>
                        </td>
                        <td>:</td>
                        <td>
                            <input name="lowerBound" value = "0">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Upper Bound</label>
                        </td>
                        <td>:</td>
                        <td>
                            <input name="upperBound" value="1">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>Iterations</label>
                        </td>
                        <td>:</td>
                        <td>
                            <input name="numberOfIterations" value="25">
                        </td>
                    </tr>
                </table>
            </fieldset>
            <p></p>
            <fieldset class="statusElem">
                <legend>
                    <strong>Execution Status</strong>
                </legend>
                <div id="statusData">

                </div>
            </fieldset>
            <p></p>
            <button type="submit" id="submitId">Submit</button>
        </form>
        <script type="text/javascript">
            $(document).ready(function () {
                $(".statusElem").hide();
                $("#submitId").click(function (e) {
                    e.preventDefault();
                    var action = $("#optimizeForm").attr('action');
                    var postData = $("#optimizeForm").serialize();
                    
                    $(".statusElem").show();
                    $("#statusData").html("<p>Please wait for result! </p>");
                    $.post(
                        action, 
                        postData, 
                        "application/json"
                    ).done(function (data) {
                        $("#statusData").html(data);
                    });
                    
                });
            });
        </script>
    </body>
</html>
