<?php

require_once __DIR__ . '/../bootstrap.php';

$objectiveEvaluator = $POSTDATA['objective'];
$initializationType = $POSTDATA['initializationType'];
$decisionSpaceDimension = $POSTDATA['dimension'];
$partsPerDimension = $POSTDATA['partsPerDimension'];
$hyperCubeDimension = $POSTDATA['hyperCubeDimension'] == '__null__'?$decisionSpaceDimension:$POSTDATA['hyperCubeDimension'];
$lowerBound = $POSTDATA['lowerBound'];
$upperBound = $POSTDATA['upperBound'];
$symbolObjectPerMembrane = $POSTDATA['symbolObjectPerMembrane'];
$eliteMatePercentage = $POSTDATA['eliteMatePercentage'];
$mutationChance = $POSTDATA['mutationChance'];
$preservePercent = 50;

$thresholds = explode('/', $POSTDATA['mergeDivideThreshold']);
$mergeThreshold = $thresholds[0];
$divideThreshold = $thresholds[1];

$numberOfIterations = $POSTDATA['numberOfIterations'];

$requestTime = new \DateTime("now");
$folderName = $requestTime->format("YmdHisu");
$saveDestination = __DIR__.'/output/'.$requestTime->format("YmdHisu");
mkdir($saveDestination);

$startTime = microtime(true);
optimize(
        $objectiveEvaluator, 
        $decisionSpaceDimension, 
        $lowerBound, 
        $upperBound, 
        $hyperCubeDimension, 
        $partsPerDimension, 
        $symbolObjectPerMembrane, 
        $initializationType, 
        $numberOfIterations, 
        $eliteMatePercentage,
        $preservePercent,
        $mergeThreshold,
        $divideThreshold,
        $mutationChance,
        true,
        $saveDestination
);
$endTime = microtime(true);

echo "<p>Excecution completed !</p>";
echo "<p>Executoin time : ".(($endTime-$startTime)).' secs</p>';
echo "<p><a href=\"show-result.php?resultId=$folderName\" target=\"_blank\">Show Results</a></p>";