<?php
require_once __DIR__ . '/../bootstrap.php';
$outputDir = __DIR__.'/output/';

$folders = glob($outputDir.'*');
$resultFolders = [];
foreach($folders as $f){
    $nameonly = str_replace($outputDir, '', $f);
    if(strlen($nameonly)<10){
        continue;
    }
    $resultFolders[] = $nameonly;
}
$count = 0;
?>
<!doctype html>
<html>
    <head>
        <title>Multi-Objective Optimization Using Membrane Inspired Evolutionary Algorithm</title>
        <script src="https://code.jquery.com/jquery-3.6.3.min.js"></script>
    </head>
    <body>
        <h1>
            Results of previous process requests
        </h1>
        <table>
            <thead>
                <tr>
                    <th>SN</th>
                    <th>Execution Time</th>
                    <th>Result</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($resultFolders as $r) : ?>
                <tr>
                    <td><?= ++$count ?></td>
                    <td><small><?= $r ?></small></td>
                    <td><a href="show-result.php?resultId=<?= $r ?>" target="_blank">Click Here</a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </body>
</html>
