<?php

use Laminas\Json\Decoder;
use Laminas\Json\Json;

require_once __DIR__ . '/../bootstrap.php';

$resultId = $GETDATA['resultId'];

if (ctype_digit($resultId) == false) {
    //header("location:results.php");
    //exit(0);
}

$output = __DIR__ . '/output/' . $resultId;

if (!is_dir($output)) {
    header("location:results.php");
    exit(0);
}

$executionDetail = Decoder::decode(file_get_contents($output . '/execution-detail.json'), Json::TYPE_ARRAY);

$iteration = $executionDetail['numberOfIterations'];

unset($executionDetail['saveProgress']);
unset($executionDetail['progressFileLocation']);

//symbol object display start
$dataSet = [];
$solutions = [];
$allMembranes = [Decoder::decode(file_get_contents($output.'/initial-membranes.json'), Json::TYPE_ARRAY)];
for($i=1; $i<=$iteration;$i++){
    $file = $output.'/iteration-'.($i).'-membranes.json';
    $allMembranes[] = Decoder::decode(file_get_contents($file), Json::TYPE_ARRAY);
}

foreach ($allMembranes as $i => $iterationWiseMembrane){
    $color = "#". bin2hex(\Laminas\Math\Rand::getBytes(3));
    $dataSet[$i] = [
        'label'=> 'Iteration '.$i,
        'data'=> [],
        'borderColor'=> $color,    
        'backgroundColor'=> $color,
        'hidden' => true,
    ];
    $solutions[$i] = $dataSet[$i];
    foreach($iterationWiseMembrane as $m){
        foreach($m['symbolObjects'] as $s){
            $dataSet[$i]['data'][] = [
                'x' => $s['coordinate'][0],
                'y' => $s['coordinate'][1],
            ];
            $solutions[$i]['data'][] = [
                'x' => $s['objectives'][0],
                'y' => $s['objectives'][1],
            ];
        }
    }
}
//symbol object display end


//Pareto-front data start
$paretoFrontData = [];
$finalFronts = Decoder::decode(
        file_get_contents($output.'/iteration-'.$iteration.'-fronts.json'), 
        Json::TYPE_ARRAY
);
$extracted = Decoder::decode(
        file_get_contents($output.'/iteration-'.$iteration.'-symbolobjects.json'), 
        Json::TYPE_ARRAY
);

//Symfony\Component\VarDumper\VarDumper::dump($finalFronts);
//Symfony\Component\VarDumper\VarDumper::dump($extracted);

foreach ($finalFronts as $key => $f){
    $color = "#". bin2hex(\Laminas\Math\Rand::getBytes(3));
    $paretoFrontData[$key] = [
        'label'=> 'Front '.($key+1),
        'data'=> [],
        'borderColor'=> $color,    
        'backgroundColor'=> $color,
        'hidden' => true,
    ];
    foreach ($f as $symbolObjId){
        $paretoFrontData[$key]['data'][] = [
            'x' => $extracted[$symbolObjId]['objectives'][0],
            'y' => $extracted[$symbolObjId]['objectives'][1],
        ];
    }
}
//Pareto-front end

?>
<!doctype html>
<html>
    <head>
        <title>Results - Multi-Objective Optimization Using Membrane Inspired Evolutionary Algorithm</title>
        <script src="assets/jquery.js"></script>
        <script src="assets/chartjs.js"></script>
    </head>
    <body>
        <h1>
            Result of "<?= $resultId ?>"
        </h1>
        <p><strong>Details of optimization operation : </strong></p>
        <div>
            <table>
                <?php foreach ($executionDetail as $key => $val) : ?>
                    <tr>
                        <td><strong><small><?= $key ?></small></strong></td>
                        <td> : </td>
                        <td><small><?= $val ?></small></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <p></p>
        <fieldset>
            <legend>
                <strong>Symbol Objects in decision space</strong>
            </legend>
            <p style="text-align: justify">
                This graph shows where the symbol objects are in decision space 
                in each iteration. Click on color box to display corresponding data.
            </p>
            <div style="width: 700px; height: 700px;"><canvas id="symbolObjects"></canvas></div>
        </fieldset>
        <p></p>
        <fieldset>
            <legend>
                <strong>Solutions in objective space</strong>
            </legend>
            <p style="text-align: justify">
                This graph shows where the first pareto-front lie in each iteration. 
                Click on color box to display corresponding data.
            </p>
            <div style="width: 700px; height: 700px;"><canvas id="objectives"></canvas></div>
        </fieldset>
        
        <fieldset>
            <legend>
                <strong>Solutions with Pareto-Front</strong>
            </legend>
            <p style="text-align: justify">
                This graph shows all the pareto-fronts of final iteration. 
                Click on color box to display corresponding data.
            </p>
            <div style="width: 700px; height: 700px;"><canvas id="solutionsPareto"></canvas></div>
        </fieldset>
        <script type="text/javascript">
            $(document).ready(function () {
                var symbolObjectCoordinateCanvas = $('#symbolObjects').get(0).getContext('2d');
                var objectivesCanvas = $('#objectives').get(0).getContext('2d');
                var solutionsPareto = $('#solutionsPareto').get(0).getContext('2d');
                var options = {
                    responsive: true,
                    maintainAspectRatio: false,
                    /*
                    scales: {
                        x: {
                          max: 1.1
                        },
                        y: {
                          max: 1.1
                        }
                    }
                     */
                };
                var coordinateChart = new Chart(symbolObjectCoordinateCanvas, {
                    type: 'scatter',
                    data: {
                        datasets: <?= Json::encode($dataSet) ?>
                    },
                    options: options
                });
                var objectiveChart = new Chart(objectivesCanvas, {
                    type: 'scatter',
                    data: {
                        datasets: <?= Json::encode($solutions) ?>
                    },
                    options: options
                });
                var solutionsParetoChart = new Chart(solutionsPareto, {
                    type: 'scatter',
                    data: {
                        datasets: <?= Json::encode($paretoFrontData) ?>
                    },
                    options: options
                });
            });
        </script>
    </body>
</html>