<?php

require_once __DIR__ . '/../../bootstrap.php';

$decisionSpaceDimension = 4;
$partsPerDimension = 4;
$hyperCubeDimension = 2;
$lowerBound = 0;
$upperBound = 1;
$symbolObjectPerMembrane = 10;

$membranes = createMembranes(
        $decisionSpaceDimension,
        $partsPerDimension,
        $hyperCubeDimension,
        $lowerBound,
        $upperBound
);

$membraneIds = array_keys($membranes);
$allSymbolObjects = [];
$symbolObjCount = 0;
foreach($membraneIds as $id){
    $range = $membranes[$id]['range'];
    $symbolObjs = [];
    $initializationValues = getInitializationValues(
            LATINHYPERCUBEINITIALIZATION, 
            $symbolObjectPerMembrane, 
            $decisionSpaceDimension, 
            $range['lower'], 
            $range['upper']
    );
    
    foreach($initializationValues as $in){
        $symbolObjs[$symbolObjCount] = [
            'id' => $symbolObjCount,
            'membraneId' => $id,
            'coordinate' => $in,
            'objectives' => getObjectiveValues(ZDT1, $in),
        ];
        $symbolObjCount++;
    }
    $membranes[$id]['symbolObjects'] = $symbolObjs;
    $membranes[$id]['fronts'] = sortPopulationByNonDomination($symbolObjs);
    $allSymbolObjects = array_merge($allSymbolObjects, $symbolObjs);
}

//displaySymbolObjectWithObjective($allSymbolObjects);
//$frontArray = sortPopulationByNonDomination($allSymbolObjects);
//Symfony\Component\VarDumper\VarDumper::dump($fronts);

//displayFronts($frontArray, $allSymbolObjects);